/*
 * Decompiled with CFR 0.152.
 */
package apicore.ptmp;

import apicore.message.LTV;
import apicore.message.LTVFactory;
import apicore.ptmp.ConnectionNegotiationProperties;
import apicore.ptmp.EncodedBuffer;
import apicore.ptmp.EncodedBufferFactory;
import apicore.ptmp.Filter;
import apicore.ptmp.PacketTracerConnection;
import apicore.ptmp.XorEncryptionFilter;
import apicore.ptmp.ZlibCompressionFilter;
import apicore.util.Logger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pipeline {
    protected LTVFactory ltvFactory;
    protected PacketTracerConnection packetTracerConnection;
    protected List<Filter> filters;
    protected ByteBuffer outBuffer;
    protected int myWriteCount = 0;
    protected int channelWriteCount = 0;

    public Pipeline(LTVFactory lTVFactory, PacketTracerConnection packetTracerConnection) {
        this.ltvFactory = lTVFactory;
        this.packetTracerConnection = packetTracerConnection;
        this.loadFilters();
        this.outBuffer = ByteBuffer.allocate(1000000);
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public LTV read() throws Exception {
        Object object;
        int n;
        ByteBuffer byteBuffer = this.packetTracerConnection.getNextMessage();
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        if (this.filters != null && !this.filters.isEmpty()) {
            for (n = this.filters.size() - 1; n >= 0; --n) {
                object = this.filters.get(n);
                byArray = object.in(byArray);
            }
        }
        n = this.packetTracerConnection.connectionNegotiationProperties().getEncoding();
        object = EncodedBufferFactory.getInstance(n);
        object.setRawBytes(byArray);
        LTV lTV = this.ltvFactory.createLTV((EncodedBuffer)object);
        if (lTV != null) {
            // empty if block
        }
        return lTV;
    }

    public void write(LTV lTV) throws IOException {
        int n = this.packetTracerConnection.connectionNegotiationProperties().getEncoding();
        EncodedBuffer encodedBuffer = EncodedBufferFactory.getInstance(n);
        lTV.encodeTypeAndPayload(encodedBuffer);
        this.writeBuffer(encodedBuffer);
        Logger.info("Pipeline sent message type: [" + lTV.getType() + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBuffer(EncodedBuffer encodedBuffer) throws IOException {
        byte[] byArray = encodedBuffer.getRawBytes();
        if (this.filters != null && !this.filters.isEmpty()) {
            for (Filter filter : this.filters) {
                byArray = filter.out(byArray);
            }
        }
        encodedBuffer.clear();
        encodedBuffer.putInt(byArray.length);
        ByteBuffer byteBuffer = this.outBuffer;
        synchronized (byteBuffer) {
            this.outBuffer.clear();
            this.outBuffer.put(encodedBuffer.getRawBytes());
            this.outBuffer.put(byArray);
            this.outBuffer.flip();
            int n = this.packetTracerConnection.write(this.outBuffer);
            this.increaseChannelWriteCount(n);
            Logger.info("Pipeline wrote # of bytes: [" + n + "]");
        }
    }

    protected void loadFilters() {
        this.filters = new ArrayList<Filter>();
        ConnectionNegotiationProperties connectionNegotiationProperties = this.packetTracerConnection.connectionNegotiationProperties();
        if (connectionNegotiationProperties.getCompression() == 2) {
            this.filters.add(new ZlibCompressionFilter());
        }
        if (connectionNegotiationProperties.getEncryption() == 2) {
            this.filters.add(new XorEncryptionFilter(connectionNegotiationProperties));
        }
    }

    public int getChannelWriteCount() {
        return this.channelWriteCount;
    }

    protected synchronized void increaseChannelWriteCount(int n) {
        this.channelWriteCount += n;
    }
}

